<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <year>  <name of author>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file		admin/admin.php
 * 	\ingroup	allscreens
 * 	\brief		This file is an example module setup page
 * 				Put some comments here
 */
// Dolibarr environment
$res = @include "../../main.inc.php"; // From htdocs directory
if (! $res) {
	$res = @include "../../../main.inc.php"; // From "custom" directory
}

global $langs, $user;

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once '../lib/allscreens.lib.php';

// Translations
$langs->load("allscreens@allscreens");

// Access control
if (! $user->admin) {
	accessforbidden();
}

// Parameters
$action = GETPOST('action', 'alpha');

/*
 * Actions
 */
$mesg="";

if ($action == 'set') {
	// save the setting
	$name = GETPOST ( 'name', 'text' );
	$value = GETPOST ( 'value', 'text' );
	$mesg = "<font class='ok'>".$langs->trans("SetupSaved")."</font>";
	$file = '../css/style.min.css';

	$oldvalue = dolibarr_get_const($db, $name);
	dolibarr_set_const($db, $name, $value ,'chaine',0,'',$conf->entity);
	$file_contents = file_get_contents($file);
	$file_contents = str_replace($oldvalue,$value,$file_contents);
	file_put_contents($file,$file_contents);
	$col1=$conf->global->ALLSCREENS_COL1;
	$col2=$conf->global->ALLSCREENS_COL2;
} elseif ($action == 'default') {
	$mesg = "<font class='ok'>".$langs->trans("DefaultSettingsMsg")."</font>";
	$source = '../css/style.min.css.default';
	$dest = '../css/style.min.css';
	copy($source,$dest);
	$col1="#5999a7";
	dolibarr_set_const($db, "ALLSCREENS_COL1", $col1,'chaine',0,'',$conf->entity);
	$col2="#f07b6e";
	dolibarr_set_const($db, "ALLSCREENS_COL2", $col2,'chaine',0,'',$conf->entity);
} else {
	// Get setting 
	$col1=$conf->global->ALLSCREENS_COL1;
	if ($col1=="")	{
		$col1="#5999a7";
		dolibarr_set_const($db, "ALLSCREENS_COL1", $col1,'chaine',0,'',$conf->entity);
	}
	$col2=$conf->global->ALLSCREENS_COL2;
	if ($col2=="")	{
		$col2="#f07b6e";
		dolibarr_set_const($db, "ALLSCREENS_COL2", $col2,'chaine',0,'',$conf->entity);
	}
}

/*
 * View
 */
$page_name = "AllScreensSetup";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="' . DOL_URL_ROOT . '/admin/modules.php">'
	. $langs->trans("BackToModuleList") . '</a>';
print_fiche_titre($langs->trans($page_name), $linkback);

// Configuration header
$head = allscreensAdminPrepareHead();
dol_fiche_head(
	$head,
	'settings',
	$langs->trans("Module500500Name"),
	0,
	"thumb@allscreens"
);

dol_htmloutput_mesg($mesg);


// Setup page goes here
print '<script type="text/javascript">';
print 'r(function(){';
print '	var els = document.getElementsByTagName("link");';
print '	var els_length = els.length;';
print '	for (var i = 0, l = els_length; i < l; i++) {';
print '    var el = els[i];';
print '	   if (el.href.search("style.min.css") >= 0) {';
print '        el.href += "?" + Math.floor(Math.random() * 100);';
print '    }';
print '	}';
print ' var fiche = document.getElementsByClassName("fiche");';
print ' fiche.className += " modules";';
print '});';
print 'function r(f){/in/.test(document.readyState)?setTimeout("r("+f+")",9):f()}';
print 'jQuery(document).ready(function() {';
print '	$("#col1").iris({width:400,palettes:true,hide:false});';
print '	$("#col2").iris({width:400,palettes:true,hide:false});';
print '});';
print '</script>';
print '<br>';
print_titre($langs->trans("Colors"));
print '<br>';

print '<form id="col1-form" method="post" action="admin.php">';
print '<input type="hidden" name="action" value="set">';
print '<input type="hidden" name="name" value="ALLSCREENS_COL1">';
print '<label for="col1">' . $langs->trans("PrimaryColor") . ' :&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</label>';
print '<input id="col1" type=text name="value" value="' . $col1 . '">';
print '<input type="submit" class="button" value="Valider">';
print '</form>';

print '<form id="col2-form" method="post" action="admin.php">';
print '<input type="hidden" name="action" value="set">';
print '<input type="hidden" name="name" value="ALLSCREENS_COL2">';
print '<label for="col2">' . $langs->trans("SecondaryColor") . ' : </label>';
print '<input id="col2" type=text name="value" value="' . $col2 . '">';
print '<input type="submit" class="button" value="Valider">';
print '</form>';

print '<br>';
print '<br>';
print '<br>';

print '<form method="post" action="admin.php">';
print '<input type="hidden" name="action" value="default">';
print '<label for="defsettings">' . $langs->trans("DefaultSettings") . ' : </label>';
print '<input type="submit" class="button" value="Valider">';
print '</form>';

print '<br>';


// Page end
dol_fiche_end();
llxFooter();
