<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <year>  <name of author>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\defgroup	AllScreens	AllScreens module
 * 	\brief		AllScreens module descriptor.
 * 	\file		core/modules/modAllScreens.class.php
 * 	\ingroup	allscreens
 * 	\brief		Description and activation file for module AllScreens
 */

include_once DOL_DOCUMENT_ROOT . "/core/modules/DolibarrModules.class.php";

/**
 * Description and activation class for module AllScreens
 */
class modAllScreens extends DolibarrModules
{

	/**
	 * 	Constructor. Define names, constants, directories, boxes, permissions
	 *
	 * 	@param	DoliDB		$db	Database handler
	 */
	public function __construct($db)
	{
		global $langs, $conf;

		$this->db = $db;

		$this->numero = 500500;
		$this->rights_class = 'allscreens';

		$this->family = "other";
		$this->name = preg_replace('/^mod/i', '', get_class($this));
		$this->description = "Affichage responsive";
		$this->version = '1.2.6';
		$this->const_name = 'MAIN_MODULE_' . strtoupper($this->name);
		$this->special = 2;
		$this->picto = 'thumb@allscreens'; 
		$this->module_parts = array(
			//'triggers' => 1,
			// Set this to 1 if module has its own login method directory
			//'login' => 0,
			// Set this to 1 if module has its own substitution function file
			//'substitutions' => 0,
			// Set this to 1 if module has its own menus handler directory
			'menus' => 1,
			// Set this to 1 if module has its own theme directory (theme)
			'theme' => 1,
			// Set this to 1 if module overwrite template dir (core/tpl)
			// 'tpl' => 0,
			// Set this to 1 if module has its own barcode directory
			//'barcode' => 0,
			// Set this to 1 if module has its own models directory
			//'models' => 0,
			// Set this to relative path of css if module has its own css file
			'css' => 'allscreens/css/style.min.css',
			// Set this to relative path of js file if module must load a js on all pages
			'js' => array('allscreens/js/custom.min.js','allscreens/js/iris.min.js'),
			// Set here all hooks context managed by module
			// 'hooks' => array('hookcontext1','hookcontext2'),
			// To force the default directories names
			// 'dir' => array('output' => 'othermodulename'),
			// Set here all workflow context managed by module
			// Don't forget to depend on modWorkflow!
			// The description translation key will be descWORKFLOW_MODULE1_YOURACTIONTYPE_MODULE2
			// You will be able to check if it is enabled with the $conf->global->WORKFLOW_MODULE1_YOURACTIONTYPE_MODULE2 constant
			// Implementation is up to you and is usually done in a trigger.
			// 'workflow' => array(
			//     'WORKFLOW_MODULE1_YOURACTIONTYPE_MODULE2' => array(
			//         'enabled' => '! empty($conf->module1->enabled) && ! empty($conf->module2->enabled)',
			//         'picto' => 'yourpicto@allscreens',
			//         'warning' => 'WarningTextTranslationKey',
			//      ),
			// ),
		);

		$this->dirs = array();

		$this->config_page_url = array("admin.php@allscreens");

		$this->hidden = false;
		$this->depends = array();
		$this->requiredby = array();
		$this->conflictwith = array();
		$this->phpmin = array(5, 3);
		$this->need_dolibarr_version = array(3, 2);
		$this->langfiles = array("allscreens@allscreens");

		// Dictionaries
		if (! isset($conf->allscreens->enabled)) {
			$conf->allscreens=new stdClass();
			$conf->allscreens->enabled = 0;
		}
		$this->dictionaries = array();

		$this->boxes = array(); // Boxes list

		// Permissions
		$this->rights = array(); // Permission array used by this module
		$r = 0;

		// Exports
		$r = 0;

		$this->const = array(
				0 => array(
					'MAIN_FORCETHEME',
					'chaine',
					'allscreens',
					'',
					1,
				),
				1 => array(
					'MAIN_OVERWRITE_THEME_RES',
					'chaine',
					'allscreens',
					'',
					1,
				),
				2 => array(
					'MAIN_MENU_STANDARD_FORCED',
					'chaine',
					'allscreens_menu.php',
					'',
					1,
				),
				3 => array(
					'MAIN_MENUFRONT_STANDARD_FORCED',
					'chaine',
					'allscreens_menu.php',
					'',
					1,
				),
				4 => array(
					'MAIN_MENU_SMARTPHONE_FORCED',
					'chaine',
					'allscreens_menu.php',
					'',
					1,
				),
				5 => array(
					'MAIN_MENUFRONT_SMARTPHONE_FORCED',
					'chaine',
					'allscreens_menu.php',
					'',
					1,
				),
				6 => array(
					'DOL_VERSION',
					'chaine',
					'',
					'Dolibarr version',
					1,
				)
		);

	}



	/**
	 * Function called when module is enabled.
	 * The init function add constants, boxes, permissions and menus
	 * (defined in constructor) into Dolibarr database.
	 * It also creates data directories
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function init($options = '')
	{
		$sql = array();

		$result = $this->loadTables();

//		$installed_ver = $conf->global->MAIN_VERSION_LAST_INSTALL;
//		$upgraded_ver = $conf->global->MAIN_VERSION_LAST_UPGRADE;
		$installed_ver = dolibarr_get_const($this->db,'MAIN_VERSION_LAST_INSTALL',0);
		$upgraded_ver = dolibarr_get_const($this->db,'MAIN_VERSION_LAST_UPGRADE',0);
		if ($upgraded_ver!="") {
			$dol_version = $upgraded_ver;
		} else {
			$dol_version = $installed_ver;
		}
//		$test = dolibarr_get_const($this->db,'MAIN_VERSION_LAST_INSTALL',0);
		dolibarr_set_const($this->db,'DOL_VERSION',$dol_version,'chaine',0,'Dolibarr version',1);
		dolibarr_set_const($this->db,'MAIN_THEME','allscreens','chaine',0,'Sets AllScreens Theme',1);
		dolibarr_set_const($this->db,'MAIN_MENU_STANDARD','allscreens_menu.php','chaine',0,'',1);
		dolibarr_set_const($this->db,'MAIN_MENUFRONT_STANDARD','allscreens_menu.php','chaine',0,'',1);
		dolibarr_set_const($this->db,'MAIN_MENU_SMARTPHONE','allscreens_menu.php','chaine',0,'',1);
		dolibarr_set_const($this->db,'MAIN_MENUFRONT_SMARTPHONE','allscreens_menu.php','chaine',0,'',1);

		$source = DOL_DOCUMENT_ROOT . '/allscreens/img/weather.new';
		$dest = DOL_DOCUMENT_ROOT . '/theme/common/weather';
	    // Loop through the folder
	    $dir = dir($source);
	    while (false !== $entry = $dir->read()) {
	        // Skip pointers
	        if ($entry == '.' || $entry == '..') {
	            continue;
	        }
	        // Deep copy directories
	        copy("$source/$entry", "$dest/$entry");
	    }

	    /* set old settings when new version activated */
	    $new = DOL_DOCUMENT_ROOT . '/allscreens/.new';
	    if (file_exists($new)) {
	    	$col1 = dolibarr_get_const($this->db,'ALLSCREENS_COL1');
	    	$col2 = dolibarr_get_const($this->db,'ALLSCREENS_COL2');
			$file = DOL_DOCUMENT_ROOT . '/allscreens/css/style.min.css';
			if ($col1!="" || $col2!="")	{
				$file_contents = file_get_contents($file);
				if ($col1!="") $file_contents = str_replace("#5999a7",$col1,$file_contents);
				if ($col2!="") $file_contents = str_replace("#f07b6e",$col2,$file_contents);
				file_put_contents($file,$file_contents);
			}
			unlink($new);
	    }
		return $this->_init($sql, $options);
	}

	/**
	 * Function called when module is disabled.
	 * Remove from database constants, boxes and permissions from Dolibarr database.
	 * Data directories are not deleted
	 *
	 * 	@param		string	$options	Options when enabling module ('', 'noboxes')
	 * 	@return		int					1 if OK, 0 if KO
	 */
	public function remove($options = '')
	{
		$sql = array();

		dolibarr_set_const($this->db,'MAIN_THEME','eldy','chaine',0,'',1);
		dolibarr_del_const($this->db,'MAIN_OVERWRITE_THEME_RES');
		dolibarr_del_const($this->db,'MAIN_FORCETHEME');
		dolibarr_del_const($this->db,'MAIN_MENU_STANDARD_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_STANDARD_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENU_SMARTPHONE_FORCED');
		dolibarr_del_const($this->db,'MAIN_MENUFRONT_SMARTPHONE_FORCED');

		$source = DOL_DOCUMENT_ROOT . '/allscreens/img/weather.org';
		$dest = DOL_DOCUMENT_ROOT . '/theme/common/weather';
	    // Loop through the folder
	    $dir = dir($source);
	    while (false !== $entry = $dir->read()) {
	        // Skip pointers
	        if ($entry == '.' || $entry == '..') {
	            continue;
	        }
	        // Deep copy directories
	        copy("$source/$entry", "$dest/$entry");
	    }

		return $this->_remove($sql, $options);
	}

	/**
	 * Create tables, keys and data required by module
	 * Files llx_table1.sql, llx_table1.key.sql llx_data.sql with create table, create keys
	 * and create data commands must be stored in directory /allscreens/sql/
	 * This function is called by this->init
	 *
	 * 	@return		int		<=0 if KO, >0 if OK
	 */
	private function loadTables()
	{
		return $this->_load_tables('/allscreens/sql/');
	}
}
