<?php
/* Copyright (C) 2003      Rodolphe Quiedeville <rodolphe@quiedeville.org>
 * Copyright (c) 2005-2008 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2005-2009 Regis Houssin        <regis.houssin@capnetworks.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *       \file       htdocs/expensereport/class/expensereportstats.class.php
 *       \ingroup    expensereport
 *       \brief      Fichier de la classe de gestion des stats des expensereport et notes de frais
 */
include_once DOL_DOCUMENT_ROOT . '/core/class/stats.class.php';
include_once DOL_DOCUMENT_ROOT . '/expensereport/class/expensereport.class.php';

/**
 *  Classe permettant la gestion des stats des expensereports et notes de frais
 */
class ExpenseReportStats extends Stats
{
    public $table_element;

    var $socid;
    var $userid;

    var $from;
    var $field;
    var $where;

	/**
	 * Constructor
	 *
	 * @param 	DoliDB		$db		   Database handler
	 * @param 	int			$socid	   Id third party
     * @param   int			$userid    Id user for filter
	 * @return 	void
	 */
	function __construct($db, $socid=0, $userid=0)
	{
		global $conf, $user;

		$this->db = $db;
        $this->socid = $socid;
        $this->userid = $userid;

		$object=new ExpenseReport($this->db);
		$this->from = MAIN_DB_PREFIX.$object->table_element;
		$this->field='total_ht';

		$this->where = " fk_statut > 0 and date_valid > '2000-01-01'";
		//$this->where.= " AND entity = ".$conf->entity;
		if ($this->socid)
		{
			$this->where.=" AND fk_soc = ".$this->socid;
		}

		// Only me and subordinates
		if (empty($user->rights->expensereport->readall) && empty($user->rights->expensereport->lire_tous))
		{
			$childids = $user->getAllChildIds();
			$childids[]=$user->id;
			$this->where.=" AND fk_user_author IN (".(join(',',$childids)).")";
		}

		if ($this->userid > 0) $this->where.=' AND fk_user_author = '.$this->userid;
	}


	/**
	 * 	Return nb of expense report per year
	 *
	 *	@return		array	Array of values
	 */
	function getNbByYear()
	{
		$sql = "SELECT YEAR(date_valid) as dm, count(*)";
		$sql.= " FROM ".$this->from;
		$sql.= " GROUP BY dm DESC";
		$sql.= " WHERE ".$this->where;

		return $this->_getNbByYear($sql);
	}


	/**
	 * 	Renvoie le nombre de facture par mois pour une annee donnee
	 *
	 *	@param	string	$year	Year to scan
	 *	@return	array			Array of values
	 */
	function getNbByMonth($year)
	{
		$sql = "SELECT MONTH(date_valid) as dm, count(*)";
		$sql.= " FROM ".$this->from;
		$sql.= " WHERE YEAR(date_valid) = ".$year;
		$sql.= " AND ".$this->where;
		$sql.= " GROUP BY dm";
        $sql.= $this->db->order('dm','DESC');

		$res=$this->_getNbByMonth($year, $sql);
		//var_dump($res);print '<br>';
		return $res;
	}


	/**
	 * 	Renvoie le montant de facture par mois pour une annee donnee
	 *
	 *	@param	int		$year		Year to scan
	 *	@return	array				Array of values
	 */
	function getAmountByMonth($year)
	{
		$sql = "SELECT date_format(date_valid,'%m') as dm, sum(".$this->field.")";
		$sql.= " FROM ".$this->from;
		$sql.= " WHERE date_format(date_valid,'%Y') = '".$year."'";
		$sql.= " AND ".$this->where;
		$sql.= " GROUP BY dm";
		$sql.= $this->db->order('dm','DESC');

		$res=$this->_getAmountByMonth($year, $sql);
		//var_dump($res);print '<br>';
		return $res;
	}

	/**
	 *	Return average amount
	 *
	 *	@param	int		$year		Year to scan
	 *	@return	array				Array of values
	 */
	function getAverageByMonth($year)
	{
		$sql = "SELECT date_format(date_valid,'%m') as dm, avg(".$this->field.")";
		$sql.= " FROM ".$this->from;
		$sql.= " WHERE date_format(date_valid,'%Y') = '".$year."'";
		$sql.= " AND ".$this->where;
		$sql.= " GROUP BY dm";
        $sql.= $this->db->order('dm','DESC');

		return $this->_getAverageByMonth($year, $sql);
	}

	/**
	 *	Return nb, total and average
	 *
	 *	@return	array				Array of values
	 */
	function getAllByYear()
	{
		$sql = "SELECT date_format(date_valid,'%Y') as year, count(*) as nb, sum(".$this->field.") as total, avg(".$this->field.") as avg";
		$sql.= " FROM ".$this->from;
		$sql.= " WHERE ".$this->where;
		$sql.= " GROUP BY year";
        $sql.= $this->db->order('year','DESC');

		return $this->_getAllByYear($sql);
	}
}

